<?php
require("conf.php");

function clear_content($content) {
    return trim(str_ireplace(['json', 'html', '*', '**', '```'], '', $content));
}

function GitHub_API($API_KEY, $type, $temp, $model, $messages) {
    $apiUrl = 'https://models.inference.ai.azure.com/chat/completions';

    $preparedMessages = array_map(function($m) {
        if (is_string($m['content'])) {
            return [
                'role'    => $m['role'],
                'content' => $m['content']
            ];
        }
        if (is_array($m['content'])) {
            return [
                'role'    => $m['role'],
                'content' => $m['content']
            ];
        }
        return $m;
    }, $messages);

    $data = json_encode([
        "messages"    => $preparedMessages,
        "temperature" => (float)$temp,
        "top_p"       => 1,
        "max_tokens"  => 8000,
        "model"       => $model
    ], JSON_UNESCAPED_UNICODE);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $API_KEY
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $error = 'cURL error: ' . curl_error($ch);
        curl_close($ch);
        return ['error' => $error];
    }

    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($type === 'array') {
        $decoded = json_decode($response, true);
        if (!is_array($decoded)) {
            return ['error' => 'Invalid JSON response', 'http_code' => $httpCode, 'raw' => $response];
        }
        $decoded['_http_code'] = $httpCode;
        return $decoded;
    } elseif ($type === 'json') {
        return $response;
    }

    return '';
}

function getNextGitHubApi(DB $db) {
    $db->dbquery("START TRANSACTION");
    try {
        $rows = null;

        try {
            $rows = $db->select("
                SELECT id, api
                FROM ai_api
                WHERE is_active = 1
                ORDER BY used_count ASC, last_used ASC
                LIMIT 1
                FOR UPDATE
            ");
        } catch (Exception $e) {
            $rows = $db->select("
                SELECT id, api
                FROM ai_api
                ORDER BY used_count ASC, last_used ASC
                LIMIT 1
                FOR UPDATE
            ");
        }

        if (!$rows) {
            $db->dbquery("ROLLBACK");
            throw new Exception("No API keys available");
        }

        $row = $rows[0];
        $id  = (int)$row['id'];

        $db->update(
            'ai_api',
            [
                'used_count' => 'used_count + 1',
                'last_used'  => 'CURRENT_TIMESTAMP'
            ],
            'id = ' . $id,
            1
        );

        $db->dbquery("COMMIT");

        return [
            'id'  => $id,
            'api' => $row['api']
        ];

    } catch (Exception $ex) {
        $db->dbquery("ROLLBACK");
        throw $ex;
    }
}

function markApiKeyBad(DB $db, $id, $reason) {
    $id = (int)$id;
	
    try {
        $db->update(
            'ai_api',
            [
                'is_active'     => '0',
                'last_error'    => $db->sqlSafe($reason),
                'last_error_at' => 'CURRENT_TIMESTAMP'
            ],
            'id = ' . $id,
            1
        );
    } catch (Exception $e) {
        try {
            $db->update(
                'ai_api',
                [
                    'is_active' => '0'
                ],
                'id = ' . $id,
                1
            );
        } catch (Exception $e2) {
        }
    }
}

function GitHub_API_Auto(DB $db, $type, $temp, $model, $messages, $retry = 3) {
    $lastErr = null;

    for ($i = 0; $i < $retry; $i++) {
        $keyRow = getNextGitHubApi($db);
        $keyId  = $keyRow['id'];
        $key    = $keyRow['api'];

        $res = GitHub_API($key, $type, $temp, $model, $messages);

        if (is_array($res) && isset($res['error'])) {
            $lastErr = $res['error'];
            continue;
        }

        if (is_array($res) && isset($res['_http_code'])) {
            $http = (int)$res['_http_code'];

            if ($http >= 200 && $http < 300) {
                return $res;
            }

            if ($http === 401 || $http === 403) {
                markApiKeyBad($db, $keyId, "HTTP $http");
            }

            $lastErr = "HTTP $http";
            continue;
        }

        if ($type === 'json') {
            return $res;
        }

        return $res;
    }

    return ['error' => $lastErr ?: 'All API keys failed'];
}

$system_content = '
أنت محرر أخبار محترف يعمل لدى موقع "العاصمة نيوز"، وخبير SEO متخصص في الأخبار السياسية والمحلية.

المهمة:
- سيصلك عنوان خبر (title) ونص خبر (content).
- يمنع منعاً باتاً تغيير المعنى أو إضافة معلومات غير موجودة.
- المطلوب فقط:
  1. إعادة صياغة احترافية خفيفة للعنوان والنص (تحرير صحفي لغوي فقط).
  2. تغيير كل ما يتعلق ب"سانا" إلى "العاصمة نيوز".
  3. تحسين الأسلوب ليكون مناسب لموقع إخباري رسمي ومتوافق مع SEO.
  4. الحفاظ الكامل على جوهر الخبر ومحتواه.
  5. يجب أن يكون الخبر وكانه حصري وخاص ل"العاصمة نيوز".

بعد ذلك:
- قم بترجمة الخبر إلى اللغات التالية:
  - العربية (محسّنة)
  - English
  - Français
  - Türkçe
  - Kurdish (Kurmanji)

الهاشتاغات:
- استخرج من مضمون الخبر هاشتاغات مناسبة.
- الحد الأدنى: 3
- الحد الأقصى: 10
- بدون تكرار
- عامة ومرتبطة بالخبر فقط (سياسة، محليات، أحداث، أسماء أماكن إن وُجدت, أسماء شخصيات إن وُجدت).

ممنوع:
- إضافة آراء
- إضافة مصادر
- تغيير الوقائع
- استخدام أسلوب إنشائي أو دعائي

الإخراج:
- أخرج النتيجة حصراً بصيغة JSON صالحة 100%.
- بدون أي نص خارج JSON.
- البنية يجب أن تكون كما يلي تماماً:

{
  "ar": {
    "title": "",
    "content": "",
    "hashtags": []
  },
  "en": {
    "title": "",
    "content": "",
    "hashtags": []
  },
  "fr": {
    "title": "",
    "content": "",
    "hashtags": []
  },
  "tr": {
    "title": "",
    "content": "",
    "hashtags": []
  },
  "ku": {
    "title": "",
    "content": "",
    "hashtags": []
  }
}
';
$title = 'فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة';
$content = '

<div class="entry-content rbct clearfix">
<p>حماة-سانا</p>



<p>فتحت الهيئة العامة لإدارة وتطوير الغاب في محافظة حماة، بالتعاون مع مديرية الطوارئ وإدارة الكوارث الطرقات، وعزلت مصارف الري التي انسدت بفعل الهطولات المطرية الغزيرة خلال الأيام الماضية.</p>



<p>وأوضح مدير المكتب الإعلامي في الهيئة محمد الشيخ في تصريح لـ”سانا”، أن كمية الهطولات المطرية في نطاق عمل الهيئة بلغت وسطياً 147 ملم، مبيناً أن الأمطار الغزيرة تسببت بغمر مساحات واسعة من الأراضي المزروعة بمحاصيل متنوعة، فيما يُتوقع أن تسهم هذه الهطولات في تحسين نسبة تنفيذ خطة الزراعة البعلية.</p>



<div class="wp-block-media-text is-stacked-on-mobile"><figure class="wp-block-media-text__media"><a href="https://cdn.sananews.sy/2026/01/IMG_0765-scaled.jpg" target="_blank" rel="noopener"><img fetchpriority="high" decoding="async" width="1024" height="683" src="https://cdn.sananews.sy/2026/01/IMG_0765-scaled.jpg" alt="IMG 0765 فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة" class="wp-image-2366172 size-full" title="فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة 2" srcset="https://cdn.sananews.sy/2026/01/IMG_0765-300x200.jpg 300w, https://cdn.sananews.sy/2026/01/IMG_0765-scaled.jpg 1024w, https://cdn.sananews.sy/2026/01/IMG_0765-768x512.jpg 768w, https://cdn.sananews.sy/2026/01/IMG_0765-1536x1024.jpg 1536w, https://cdn.sananews.sy/2026/01/IMG_0765-2048x1365.jpg 2048w, https://cdn.sananews.sy/2026/01/IMG_0765-330x220.jpg 330w, https://cdn.sananews.sy/2026/01/IMG_0765-420x280.jpg 420w, https://cdn.sananews.sy/2026/01/IMG_0765-615x410.jpg 615w" sizes="(max-width: 1024px) 100vw, 1024px"></a></figure><div class="wp-block-media-text__content">
<p>وأشار الشيخ إلى أن الهيئة استجابت لطلبات الفلاحين في منطقة الغاب، المتعلقة بفتح الطرقات وتعزيل قنوات الري في قرى وبلدات عناب، شطحة، الزقوم، الشريعة، قبر فضة، الصقلية، والحميدية، إضافة إلى أعمال تعزيل في قرية شيزر بريف حماة الشمالي الغربي.</p>
</div></div>



<p>وتواصل الجهات المختصة في محافظة حماة متابعة الأوضاع الميدانية ضمن خطط الطوارئ المعتمدة للحد من آثار الحالة الجوية السائدة، حيث تم إنشاء غرفة طوارئ وتنفيذ جولات ميدانية في منطقة الغاب بريف المحافظة الغربي التي شهدت هطولات مطرية غزيرة وعواصف رعدية.</p>



<figure class="wp-block-gallery has-nested-images columns-2 is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex">
<figure class="wp-block-image size-large"><a class="media-link" href="https://cdn.sananews.sy/2026/01/IMG_0734-scaled.jpg" target="_blank" rel="noopener"><img decoding="async" width="1024" height="683" data-id="2366176" src="https://cdn.sananews.sy/2026/01/IMG_0734-1024x683.jpg" alt="IMG 0734 فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة" class="wp-image-2366176" title="فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة 3" srcset="https://cdn.sananews.sy/2026/01/IMG_0734-300x200.jpg 300w, https://cdn.sananews.sy/2026/01/IMG_0734-1024x683.jpg 1024w, https://cdn.sananews.sy/2026/01/IMG_0734-768x512.jpg 768w, https://cdn.sananews.sy/2026/01/IMG_0734-1536x1024.jpg 1536w, https://cdn.sananews.sy/2026/01/IMG_0734-2048x1365.jpg 2048w, https://cdn.sananews.sy/2026/01/IMG_0734-330x220.jpg 330w, https://cdn.sananews.sy/2026/01/IMG_0734-420x280.jpg 420w, https://cdn.sananews.sy/2026/01/IMG_0734-615x410.jpg 615w" sizes="(max-width: 1024px) 100vw, 1024px"></a></figure>



<figure class="wp-block-image size-large"><a class="media-link" href="https://cdn.sananews.sy/2026/01/IMG_0767-scaled.jpg" target="_blank" rel="noopener"><img decoding="async" width="1024" height="683" data-id="2366173" src="https://cdn.sananews.sy/2026/01/IMG_0767-1024x683.jpg" alt="IMG 0767 فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة" class="wp-image-2366173" title="فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة 4" srcset="https://cdn.sananews.sy/2026/01/IMG_0767-300x200.jpg 300w, https://cdn.sananews.sy/2026/01/IMG_0767-1024x683.jpg 1024w, https://cdn.sananews.sy/2026/01/IMG_0767-768x512.jpg 768w, https://cdn.sananews.sy/2026/01/IMG_0767-1536x1024.jpg 1536w, https://cdn.sananews.sy/2026/01/IMG_0767-2048x1365.jpg 2048w, https://cdn.sananews.sy/2026/01/IMG_0767-330x220.jpg 330w, https://cdn.sananews.sy/2026/01/IMG_0767-420x280.jpg 420w, https://cdn.sananews.sy/2026/01/IMG_0767-615x410.jpg 615w" sizes="(max-width: 1024px) 100vw, 1024px"></a></figure>



<figure class="wp-block-image size-large"><a class="media-link" href="https://cdn.sananews.sy/2026/01/IMG_0791-scaled.jpg" target="_blank" rel="noopener"><img loading="lazy" decoding="async" width="1024" height="683" data-id="2366174" src="https://cdn.sananews.sy/2026/01/IMG_0791-1024x683.jpg" alt="IMG 0791 فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة" class="wp-image-2366174" title="فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة 5" srcset="https://cdn.sananews.sy/2026/01/IMG_0791-300x200.jpg 300w, https://cdn.sananews.sy/2026/01/IMG_0791-1024x683.jpg 1024w, https://cdn.sananews.sy/2026/01/IMG_0791-768x512.jpg 768w, https://cdn.sananews.sy/2026/01/IMG_0791-1536x1024.jpg 1536w, https://cdn.sananews.sy/2026/01/IMG_0791-2048x1365.jpg 2048w, https://cdn.sananews.sy/2026/01/IMG_0791-330x220.jpg 330w, https://cdn.sananews.sy/2026/01/IMG_0791-420x280.jpg 420w, https://cdn.sananews.sy/2026/01/IMG_0791-615x410.jpg 615w" sizes="auto, (max-width: 1024px) 100vw, 1024px"></a></figure>



<figure class="wp-block-image size-large"><a class="media-link" href="https://cdn.sananews.sy/2026/01/IMG_0667-scaled.jpg" target="_blank" rel="noopener"><img loading="lazy" decoding="async" width="1024" height="683" data-id="2366175" src="https://cdn.sananews.sy/2026/01/IMG_0667-1024x683.jpg" alt="IMG 0667 فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة" class="wp-image-2366175" title="فتح طرقات وتعزيل مصارف الري المتضررة جراء العاصفة المطرية في الغاب بريف حماة 6" srcset="https://cdn.sananews.sy/2026/01/IMG_0667-300x200.jpg 300w, https://cdn.sananews.sy/2026/01/IMG_0667-1024x683.jpg 1024w, https://cdn.sananews.sy/2026/01/IMG_0667-768x512.jpg 768w, https://cdn.sananews.sy/2026/01/IMG_0667-1536x1024.jpg 1536w, https://cdn.sananews.sy/2026/01/IMG_0667-2048x1365.jpg 2048w, https://cdn.sananews.sy/2026/01/IMG_0667-330x220.jpg 330w, https://cdn.sananews.sy/2026/01/IMG_0667-420x280.jpg 420w, https://cdn.sananews.sy/2026/01/IMG_0667-615x410.jpg 615w" sizes="auto, (max-width: 1024px) 100vw, 1024px"></a></figure>
</figure>
</div>

';
$messages = [
    [
        "role" => "system",
        "content" => $system_content
    ],
    [
        "role" => "user",
        "content" => json_encode([
            "title"   => $title,
            "content" => $content
        ], JSON_UNESCAPED_UNICODE)
    ]
];


$res = GitHub_API_Auto($db, 'array', 0.5, 'gpt-4.1-mini', $messages, 3);
$all_array = $res['choices'][0]['message']['content'];
header('Content-Type: application/json; charset=utf-8');
print $all_array;
















